# Game: SHADOWSPECT

No game-specific readme content prepared

## Field Day Open Game Data

Retrieved from https://fielddaylab.wisc.edu/opengamedata
These anonymous data are provided in service of future educational data mining research.
They are made available under the Creative Commons CCO 1.0 Universal license.
See https://creativecommons.org/publicdomain/zero/1.0/

### Suggested citation

#### Field Day. (2019). Open Educational Game Play Logs - [dataset ID]. Retrieved [today's date] from https://opengamedata.fielddaylab.wisc.edu/

## Database Columns

The individual columns recorded in the database for this game.

**session_id** : *str* - session_id, Unique identifier for the gameplay session  
**app_id** : *str* - app_id, A string identifying which game from which the event came  
**timestamp** : *datetime* - timestamp, The time when the event was logged  
**event_name** : *str* - event_name, The type of event logged  
**event_data** : *json* - event_data, Data specific to an event type, encoded as a JSON string  
**event_source** : *enum('GAME', 'GENERATED')* - event_source, An enum member indicating whether the event was generated by the Game, or by a Detector  
**app_version** : *str* - app_version, The version of the game from which the event came  
**app_branch** : *str* - app_branch, The branch of the game from which the event came  
**log_version** : *str* - log_version, The version of the logging code for the game from which the event came  
**offset** : *timezone* - offset, The local offset of the event time from GMT  
**user_id** : *str* - user_id, A custom, per-player ID, only exists if player entered an ID on one of our custom portal pages, else null  
**user_data** : *json* - user_data, Metadata specific to a user, encoded as a JSON string  
**game_state** : *json* - game_state, Metadata about the state of the game when the event occurred, encoded as a JSON string  
**index** : *int* - index, Counter of events in the session, from 0. A row with session_n = i is the (i+1)-th event of the session  

## Event Object Elements

The elements (member variables) of each Event object, available to programmers when writing feature extractors. The right-hand side shows which database column(s) are mapped to a given element.

**session_id** = Column '*session_id*' (index 0)  
**app_id** = Column '*app_id*' (index 1)  
**timestamp** = Column '*timestamp*' (index 2)  
**event_name** = Column '*event_name*' (index 3)  
**event_data** = Column '*event_data*' (index 4)  
**event_source** = Column '*event_source*' (index 5)  
**app_version** = Column '*app_version*' (index 6)  
**app_branch** = Column '*app_branch*' (index 7)  
**log_version** = Column '*log_version*' (index 8)  
**time_offset** = Column '*offset*' (index 9)  
**user_id** = Column '*user_id*' (index 10)  
**user_data** = Column '*user_data*' (index 11)  
**game_state** = Column '*game_state*' (index 12)  
**event_sequence_index** = Column '*index*' (index 13)  



## Logged Events  

The individual fields encoded in the *game_state* and *user_data* Event element for all event types, and the fields in the *event_data* Event element for each individual event type logged by the game.  

### Enums  

| **Name** | **Values** |
| ---      | ---        |  

### Game State  

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |  

### User Data  

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |  

### **start_game**

The launch of the game.

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| group | string | Feature of the data that allowed sessions to be tagged with a teacher name. | |
| version_num | string | Game Version Number | |
| env_configs | dict{} | Environment Variables | |
| game_id | string | Unique identifier assigned by the browser | |  

### **login_user**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| game_id | string | Unique identifier assigned by the browser | |
| user | string | NYI: The two word code assigned to the player as their save code. | |
| group | string | Feature of the data that allowed sessions to be tagged with a teacher name. | |  

### **disconnect**

The disconnect is generated by the backend when the websocket disconnects (browser decides, when user closes or navigates away usually). I believe it will also timeout if it doesn't get any data for 86400 seconds (24 hours)

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |  

### **exit_to_menu**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| user | string | N/A | |
| group | string | Feature of the data that allowed sessions to be tagged with a teacher name. | |
| timeStamp | double | Time - unsure if server or local. | |
| screenPos | dict | N/A | |
| actionIndex | int | N/A | |  

### **start_level**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| user | string | N/A | |
| group | string | Feature of the data that allowed sessions to be tagged with a teacher name. | |
| task_id | string | N/A | |
| set_id | string | N/A | |
| fullscreen | bool | N/A | |
| resolution | dict | N/A | |
| conditions | dict | N/A | |  

### **puzzle_started**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| user | string | N/A | |
| group | string | Feature of the data that allowed sessions to be tagged with a teacher name. | |
| task_id | string | N/A | |
| set_id | string | N/A | |
| timeStamp | double | Time - unsure if server or local. | |
| screenPos | dict | N/A | |
| actionIndex | int | N/A | |  

### **puzzle_complete**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| user | string | N/A | |
| group | string | Feature of the data that allowed sessions to be tagged with a teacher name. | |
| task_id | string | N/A | |
| set_id | string | N/A | |
| timeStamp | double | Time - unsure if server or local. | |
| screenPos | dict | N/A | |
| actionIndex | int | N/A | |  

### **restart_puzzle**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| user | string | N/A | |
| group | string | Feature of the data that allowed sessions to be tagged with a teacher name. | |
| timeStamp | double | Time - unsure if server or local. | |
| screenPos | dict | N/A | |
| actionIndex | int | N/A | |  

### **create_shape**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| user | string | N/A | |
| group | string | Feature of the data that allowed sessions to be tagged with a teacher name. | |
| timeStamp | double | Time - unsure if server or local. | |
| screenPos | dict | N/A | |
| actionIndex | int | N/A | |
| color | int | N/A | |
| spawnPosition | dict | N/A | |
| input | string | N/A | |
| changeMode | bool | N/A | |
| objSerialization | int | N/A | |
| shapeType | int | N/A | |  

### **delete_shape**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| user | string | N/A | |
| group | string | N/A | |
| timeStamp | double | Time - unsure if server or local. | |
| screenPos | dict | N/A | |
| actionIndex | int | N/A | |
| color | int | N/A | |
| input | string | N/A | |
| changeMode | bool | N/A | |
| deletedShapes | List[int] | N/A | |  

### **select_shape**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| user | string | N/A | |
| group | string | N/A | |
| timeStamp | double | Time - unsure if server or local. | |
| screenPos | dict | N/A | |
| actionIndex | int | N/A | |
| input | string | N/A | |
| newSelection | List[int] | N/A | |
| prevSelection | List[int] | N/A | |  

### **deselect_shape**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| user | string | N/A | |
| group | string | N/A | |
| timeStamp | double | Time - unsure if server or local. | |
| screenPos | dict | N/A | |
| actionIndex | int | N/A | |
| input | string | N/A | |
| newSelection | List[int] | N/A | |
| prevSelection | List[int] | N/A | |  

### **select_shape_add**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| user | string | N/A | |
| group | string | N/A | |
| timeStamp | double | Time - unsure if server or local. | |
| screenPos | dict | N/A | |
| actionIndex | int | N/A | |
| input | string | N/A | |
| newSelection | List[int] | N/A | |
| prevSelection | List[int] | N/A | |  

### **move_shape**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| user | string | N/A | |
| group | string | N/A | |
| timeStamp | double | Time - unsure if server or local. | |
| screenPos | dict | N/A | |
| actionIndex | int | N/A | |
| input | string | N/A | |
| selectedObjects | List[int] | N/A | |
| prevPositions | List[dict] | N/A | |
| targetOffset | dict | N/A | |
| validMove | bool | N/A | |  

### **rotate_shape**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| user | string | N/A | |
| group | string | N/A | |
| timeStamp | double | Time - unsure if server or local. | |
| screenPos | dict | N/A | |
| actionIndex | int | N/A | |
| input | string | N/A | |
| selectedObject | int | N/A | |
| rotationOffset | dict | N/A | |  

### **scale_shape**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| user | string | N/A | |
| group | string | N/A | |
| timeStamp | double | N/A | |
| screenPos | dict | N/A | |
| actionIndex | int | N/A | |
| input | string | N/A | |
| selectedObject | int | N/A | |
| newScale | dict | N/A | |
| prevScale | dict | N/A | |  

### **mode_change**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| user | string | N/A | |
| group | string | N/A | |
| timeStamp | double | N/A | |
| screenPos | dict | N/A | |
| actionIndex | int | N/A | |
| input | string | N/A | |
| mode | int | N/A | |
| prevMode | int | N/A | |
| xfmMode | int | N/A | |
| prevXfmMode | int | N/A | |
| shape | int | N/A | |
| prevShape | int | N/A | |  

### **click_nothing**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| user | string | N/A | |
| group | string | N/A | |
| timeStamp | double | N/A | |
| screenPos | dict | N/A | |
| actionIndex | int | N/A | |  

### **rotate_view**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| user | string | N/A | |
| group | string | N/A | |
| timeStamp | double | N/A | |
| screenPos | dict | N/A | |
| actionIndex | int | N/A | |
| input | string | N/A | |
| freeformDrag | bool | N/A | |
| freeformRelease | bool | N/A | |
| targetCam | int | N/A | |
| prevCam | int | N/A | |  

### **check_solution**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| user | string | N/A | |
| group | string | N/A | |
| timeStamp | double | N/A | |
| screenPos | dict | N/A | |
| actionIndex | int | N/A | |
| correct | List[bool] | N/A | |  

### **toogle_paint_display**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| user | string | N/A | |
| group | string | N/A | |
| timeStamp | double | N/A | |
| screenPos | dict | N/A | |
| actionIndex | int | N/A | |
| isOpen | bool | N/A | |  

### **palette_change**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| user | string | N/A | |
| group | string | N/A | |
| timeStamp | double | N/A | |
| screenPos | dict | N/A | |
| actionIndex | int | N/A | |
| newPalette | int | N/A | |
| prevPalette | int | N/A | |
| changeMode | bool | N/A | |  

### **paint**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| user | string | N/A | |
| group | string | N/A | |
| timeStamp | double | N/A | |
| screenPos | dict | N/A | |
| actionIndex | int | N/A | |
| shapeIndex | int | N/A | |
| newColor | int | N/A | |
| prevColor | int | N/A | |  

### **toggle_snapshot_display**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| user | string | N/A | |
| group | string | N/A | |
| timeStamp | double | N/A | |
| screenPos | dict | N/A | |
| actionIndex | int | N/A | |
| isOpen | bool | N/A | |  

### **snapshot**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| user | string | N/A | |
| group | string | N/A | |
| timeStamp | double | N/A | |
| screenPos | dict | N/A | |
| actionIndex | int | N/A | |
| cameraAngle | int | N/A | |  

### **undo_action**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| user | string | N/A | |
| group | string | N/A | |
| timeStamp | double | N/A | |
| screenPos | dict | N/A | |
| input | string | N/A | |
| actionIndex | int | N/A | |
| targetedActionIndex | int | N/A | |  

### **redo_action**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| user | string | N/A | |
| group | string | N/A | |
| timeStamp | double | N/A | |
| screenPos | dict | N/A | |
| input | string | N/A | |
| actionIndex | int | N/A | |
| targetedActionIndex | int | N/A | |  

## Detected Events  

The custom, data-driven Events calculated from this game's logged events by OpenGameData when an 'export' is run.  

None  

## Processed Features  

The features/metrics calculated from this game's event logs by OpenGameData when an 'export' is run.  

**SessionID** : *str*, *Aggregate feature*   
The player's session ID number for this play session  
  

**FunnelByUser** : *List[float | int]*, *Aggregate feature*  (disabled)  
Funnel of puzzles for this play session  
  

**LevelsOfDifficulty** : *List[bool | int | timedelta]*, *Aggregate feature*   
Set of features for each level describing the difficulty of a puzzle (on-going-work)  
  

**SequenceBetweenPuzzles** : **, *Aggregate feature*  (disabled)  
Sequence of puzzles and its funnel stage reached of a given session  
  

**MoveShapeCount** : *int*, *Per-count feature*   
Total number of shape moves in a given session  
  

## Other Elements  

Other (potentially non-standard) elements specified in the game's schema, which may be referenced by event/feature processors.  

db_columns : {'event_name': 'The name of the event', 'event_params': 'A repeated record of the parameters associated with this event', 'user_id': 'The user ID set via the setUserId API', 'device': 'A record of device information', 'geo': "A record of the user's geographic information", 'platform': 'The platform on which the app was built', 'session_id': 'ID for the current play session', 'timestamp': 'Datetime when the event was logged'}  

### Other Ranges  

Extra ranges specified in the game's schema, which may be referenced by event/feature processors.  

level_range : range(0, 0)

No changelog prepared

