# Game: MAGNET

No game-specific readme content prepared

## Field Day Open Game Data

Retrieved from https://fielddaylab.wisc.edu/opengamedata
These anonymous data are provided in service of future educational data mining research.
They are made available under the Creative Commons CCO 1.0 Universal license.
See https://creativecommons.org/publicdomain/zero/1.0/

### Suggested citation

#### Field Day. (2019). Open Educational Game Play Logs - [dataset ID]. Retrieved [today's date] from https://opengamedata.fielddaylab.wisc.edu/

## Database Columns

The individual columns recorded in the database for this game.

**session_id** : *str* - session_id, Unique identifier for the gameplay session  
**app_id** : *str* - app_id, A string identifying which game from which the event came  
**timestamp** : *datetime* - timestamp, The time when the event was logged  
**event_name** : *str* - event_name, The type of event logged  
**event_data** : *json* - event_data, Data specific to an event type, encoded as a JSON string  
**event_source** : *enum('GAME', 'GENERATED')* - event_source, An enum member indicating whether the event was generated by the Game, or by a Detector  
**app_version** : *str* - app_version, The version of the game from which the event came  
**app_branch** : *str* - app_branch, The branch of the game from which the event came  
**log_version** : *str* - log_version, The version of the logging code for the game from which the event came  
**offset** : *timezone* - offset, The local offset of the event time from GMT  
**user_id** : *str* - user_id, A custom, per-player ID, only exists if player entered an ID on one of our custom portal pages, else null  
**user_data** : *json* - user_data, Metadata specific to a user, encoded as a JSON string  
**game_state** : *json* - game_state, Metadata about the state of the game when the event occurred, encoded as a JSON string  
**index** : *int* - index, Counter of events in the session, from 0. A row with session_n = i is the (i+1)-th event of the session  

## Event Object Elements

The elements (member variables) of each Event object, available to programmers when writing feature extractors. The right-hand side shows which database column(s) are mapped to a given element.

**session_id** = Column '*session_id*' (index 0)  
**app_id** = Column '*app_id*' (index 1)  
**timestamp** = Column '*timestamp*' (index 2)  
**event_name** = Column '*event_name*' (index 3)  
**event_data** = Column '*event_data*' (index 4)  
**event_source** = Column '*event_source*' (index 5)  
**app_version** = Column '*app_version*' (index 6)  
**app_branch** = Column '*app_branch*' (index 7)  
**log_version** = Column '*log_version*' (index 8)  
**time_offset** = Column '*offset*' (index 9)  
**user_id** = Column '*user_id*' (index 10)  
**user_data** = Column '*user_data*' (index 11)  
**game_state** = Column '*game_state*' (index 12)  
**event_sequence_index** = Column '*index*' (index 13)  



## Logged Events  

The individual fields encoded in the *game_state* and *user_data* Event element for all event types, and the fields in the *event_data* Event element for each individual event type logged by the game.  

### Enums  

| **Name** | **Values** |
| ---      | ---        |  

### Game State  

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |  

### User Data  

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |  

### **COMPLETE**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| guessScore | Dict | N/A |**northDist** : float, **southDist** : float |
| guessScoreIfSwitched | Dict | N/A |**northPoleToSouthGuess** : float, **southPoleToNorthGuess** : float |
| numCompasses | int | N/A | |
| ironFilingsUsed | boolean | N/A | |
| magneticFilmUsed | boolean | N/A | |
| levelTime | float | N/A | |
| numLevels | int | N/A | |
| numTimesPolesMoved | int | N/A | |
| magnetLocation | Dict | N/A |**xNorth** : float, **yNorth** : float, **xSouth** : float, **ySouth** : float |
| event_custom | COMPLETE | N/A | |  

### **DRAG_TOOL**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| event_custom | DRAG_TOOL | N/A | |
| toolType | string | N/A | |
| dragTime | float | N/A | |
| location | Dict | N/A |**x** : int, **y** : int |
| toolNum | float | N/A | |  

### **DRAG_POLE**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| event_custom | DRAG_POLE | N/A | |
| poleType | string | N/A | |
| dragTime | float | N/A | |
| location | Dict | N/A |**x** : int, **y** : int |
| numTimesMoved | int | N/A | |
| distToPole | float | N/A | |
| numToolsUsed | int | N/A | |  

### **PLAYGROUND_EXIT**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| event_custom | PLAYGROUND_EXIT | N/A | |
| timeSpent | float | N/A | |
| numThingsDragged | int | N/A | |  

### **TUTORIAL_EXIT**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| event_custom | TUTORIAL_EXIT | N/A | |
| timeSpent | float | N/A | |  

## Detected Events  

The custom, data-driven Events calculated from this game's logged events by OpenGameData when an 'export' is run.  

None  

## Processed Features  

The features/metrics calculated from this game's event logs by OpenGameData when an 'export' is run.  

**sessionID** : **, *Aggregate feature*  (disabled)  
The player's session ID number for this play session  
  

**persistentSessionID** : **, *Aggregate feature*  (disabled)  
The session ID for the player's device, persists across multiple players using the same device.  
  

**sessionEventCount** : **, *Aggregate feature*  (disabled)  
The total number of events across the entire session  
  

**sessionTime** : **, *Aggregate feature*  (disabled)  
The total number of seconds spent  
  

**numberOfCompletePlays** : **, *Aggregate feature*  (disabled)  
The number of times the player played the game  
  

**averageScore** : **, *Aggregate feature*  (disabled)  
The average score across all complete plays  
  

## Other Elements  

Other (potentially non-standard) elements specified in the game's schema, which may be referenced by event/feature processors.  

### Other Ranges  

Extra ranges specified in the game's schema, which may be referenced by event/feature processors.  

level_range : range(0, 219)

No changelog prepared

