# Game: LAKELAND

No game-specific readme content prepared

## Field Day Open Game Data

Retrieved from https://fielddaylab.wisc.edu/opengamedata
These anonymous data are provided in service of future educational data mining research.
They are made available under the Creative Commons CCO 1.0 Universal license.
See https://creativecommons.org/publicdomain/zero/1.0/

### Suggested citation

#### Field Day. (2019). Open Educational Game Play Logs - [dataset ID]. Retrieved [today's date] from https://opengamedata.fielddaylab.wisc.edu/

## Database Columns

The individual columns recorded in the database for this game.

**session_id** : *str* - session_id, Unique identifier for the gameplay session  
**app_id** : *str* - app_id, A string identifying which game from which the event came  
**timestamp** : *datetime* - timestamp, The time when the event was logged  
**event_name** : *str* - event_name, The type of event logged  
**event_data** : *json* - event_data, Data specific to an event type, encoded as a JSON string  
**event_source** : *enum('GAME', 'GENERATED')* - event_source, An enum member indicating whether the event was generated by the Game, or by a Detector  
**app_version** : *str* - app_version, The version of the game from which the event came  
**app_branch** : *str* - app_branch, The branch of the game from which the event came  
**log_version** : *str* - log_version, The version of the logging code for the game from which the event came  
**offset** : *timezone* - offset, The local offset of the event time from GMT  
**user_id** : *str* - user_id, A custom, per-player ID, only exists if player entered an ID on one of our custom portal pages, else null  
**user_data** : *json* - user_data, Metadata specific to a user, encoded as a JSON string  
**game_state** : *json* - game_state, Metadata about the state of the game when the event occurred, encoded as a JSON string  
**index** : *int* - index, Counter of events in the session, from 0. A row with session_n = i is the (i+1)-th event of the session  

## Event Object Elements

The elements (member variables) of each Event object, available to programmers when writing feature extractors. The right-hand side shows which database column(s) are mapped to a given element.

**session_id** = Column '*session_id*' (index 0)  
**app_id** = Column '*app_id*' (index 1)  
**timestamp** = Column '*timestamp*' (index 2)  
**event_name** = Column '*event_name*' (index 3)  
**event_data** = Column '*event_data*' (index 4)  
**event_source** = Column '*event_source*' (index 5)  
**app_version** = Column '*app_version*' (index 6)  
**app_branch** = Column '*app_branch*' (index 7)  
**log_version** = Column '*log_version*' (index 8)  
**time_offset** = Column '*offset*' (index 9)  
**user_id** = Column '*user_id*' (index 10)  
**user_data** = Column '*user_data*' (index 11)  
**game_state** = Column '*game_state*' (index 12)  
**event_sequence_index** = Column '*index*' (index 13)  



## Logged Events  

The individual fields encoded in the *game_state* and *user_data* Event element for all event types, and the fields in the *event_data* Event element for each individual event type logged by the game.  

### Enums  

| **Name** | **Values** |
| ---      | ---        |  

### Game State  

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |  

### User Data  

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |  

### **GAMESTATE**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| tiles | N/A | pako.gzip(uint8_tile_array()).join() | Gzipped tile [data matrix](#DataMatrices). | |
| farmbits | N/A | pako.gzip(uint8_farmbit_array()).join() | Gzipped farmbit [data matrix](#DataMatrices). | |
| items | N/A | pako.gzip(uint8_item_array()).join() | Gzipped item [data matrix](#DataMatrices). | |
| money | N/A | gg.money | current money | |
| speed | N/A | gg.speed | current game speed (see [Speed](#SpeedConst)) | |
| achievements | N/A | achievements | A boolean array of whether the player has gotten the [achievement](#Achievements) at that index. | |
| num_checkpoints_completed | N/A | get_num_checkpoints_completed() | Number of tutorials began + number of tutorial ended. Includes tutorials skipped. | |
| raining | N/A | gg.b.raining | Boolean - currently raining or not. | |
| curr_selection_type | N/A | gg.inspector.detailed_type | Current selection [inspector content](#InspectorContent) index. (Note that because the game currently (as of 7/25) logs gamestate only after buys, this will always be the type of tile.) | |
| curr_selection_data | N/A | detailed_data() | SelectFarmbit/SelectItem/SelectTile data, depending on the curr_selection_type. | |
| camera_center | N/A | prev_center_txty | Tile that the game is currently centered on. | |
| gametime | N/A | time | Metric to count speed-adjusted time. Based on number of ticks. | |
| timestamp | N/A | now | current client time | |
| num_food_produced | N/A | num_food_produced | total number of food produced (not bought) since the start of the game | | |
| num_milk_produced | N/A | num_milk_produced | total number of milk produced (not bought) since the start of the game | | |
| num_poop_produced | N/A | num_poop_produced | total number of poop produced (not bought) since the start of the game | | |  

### **STARTGAME**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| tile_states | N/A | tile_states | 2500 element array of tile state indices. | |
| tile_nutritions | N/A | tile_nutritions | 2500 element array of tile nutritions on a scale 0-255. | |  

### **CHECKPOINT**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| event_category | N/A | arguments[2] | Usually (always?) begin or end | |
| event_label | N/A | arguments[2] | Tutorial name. For example, the name of the tutorial that teaches the player how to build a house is called 'build_a_house' | |
| event_type | N/A | arguments[1] | Usually (always?) tutorial | |
| blurb_history | N/A | flush_blurb_history(now) | List of client time relative to now for each blurb popup. (Blurbs are now logged here instead of the [blurb](#blurb) event.) | |
| client_time | N/A | now | current client time | |
| continue | N/A | gg.continue_ls ? 1: 0 | 1/0 boolean to indicate whether the player continued or not | |
| language | N/A | g.scenes[1].language_toggle.on ? 'espanol':'english' | language of the game | |
| audio | N/A | AUDIO ? 1: 0 | 1/0 boolean to indicate whether audio was toggled on or not | |
| fullscreen | N/A | g.scenes[1].fullscreen_toggle.on ? 1:  | 1/0 boolean to indicate whether the game was toggled into fullscreen whether or not | |  

### **SELECTTILE**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| tile | N/A | tile_data_short(t) | See [Data Short](#DataShort). | |
| marks | N/A | t.marks | Tile [mark indices](#Mark). | |  

### **SELECTFARMBIT**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| farmbit | N/A | farmbit_data_short(f) | See [Data Short](#DataShort). | |  

### **SELECTITEM**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| item | N/A | item_data_short(it) | See [Data Short](#DataShort). | |
| mark | N/A | it.mark | Item [mark index](#Mark). | |  

### **SELECTBUY**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| buy | N/A | buy | [Buy index](#Buys). | |
| cost | N/A | gg.shop.buy_cost(buy) | Cost of buy | |
| curr_money | N/A | gg.money | Current money | |
| success | N/A | gg.money>=gg.shop.buy_cost(buy) | Boolean. Whether the buy can be selected or not. (Cannot select a buy that cannot be paid for.) | |  

### **BUY**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| buy | N/A | gg.shop.selected_buy | [Buy index](#Buys). | |
| tile | N/A | tile_data_short(gg.b.hover_t) | [Data Short](#DataShort) for the tile the buy will be placed on. | |
| success | N/A | gg.b.placement_valid(gg.b.hover_tgg.shop.selected_buy) | Boolean. Whether the buy can be put on the tile. If not, buy fails. | |
| buy_hovers | N/A | flush_buy_hovers(now) | List of tile [Data Short](#DataShort) appended with client time before now for each hovered tile since either selectbuy log or the previous buy log. | |
| client_time | N/A | now | current client time | |  

### **CANCELBUY**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| selected_buy | N/A | buy | [Buy index](#Buys). | |
| cost | N/A | gg.shop.buy_cost(buy) | Cost of buy. | |
| curr_money | N/A | gg.money | Current money. | |
| buy_hovers | N/A | flush_buy_hovers(now) | List of tile [Data Short](#DataShort) appended with client time before now for each hovered tile since either selectbuy log or the previous buy log. | |
| client_time | N/A | now | current client time | |  

### **ROADBUILDS**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| road_builds | N/A | flush_road_hovers(now) | List of tile [Data Short](#DataShort) appended with client time before now for each tile a road was built on. | |
| client_time | N/A | now | current client time | |  

### **TILEUSESELECT**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| tile | N/A | tile_data_short(t) | See [Data Short](#DataShort). | |
| marks | N/A | t.marks | Tile [mark indices](#Mark). | |  

### **ITEMUSESELECT**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| item | N/A | item_data_short(it) | See [Data Short](#DataShort). | |
| prev_mark | N/A | it.mark | Item [mark index](#Mark). | |  

### **TOGGLENUTRITION**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| to_state | N/A | gg.b.nutrition_view | 1 if nutrition view is being turned on, 0 if turned off. | |
| tile_nutritions | N/A | nutrition_array() | 2500 element array of tile nutritions on a scale 0-255. | |  

### **TOGGLESHOP**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| shop_open | N/A | gg.shop.open | 1 if the shop view is being opened, 0 if closed. | |  

### **TOGGLEACHIEVEMENTS**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| achievements_open | N/A | gg.achievements.open | 1 if the achievement view is being opened, 0 if closed. | |  

### **SKIPTUTORIAL**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| (none) | N/A |  | Event itself indicates that the player skipped a tutorial (the tutorial skipped is the last tutorial event logged). | |  

### **SPEED**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| cur_speed | N/A | gg.speed | To [speed](#SpeedConst) index. | |
| prev_speed | N/A | speed | From [speed](#SpeedConst) index. | |
| manual | N/A | manual_speed_bool | bool: 1 if speed was manually changed, 0 if not  | |  

### **ACHIEVEMENT**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| achievement | N/A | i | [Achievement](#Achievements) index. | |  

### **FARMBITDEATH**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| farmbit | N/A | farmbit_data_short(f) | See [Data Short](#DataShort). | |
| grave | N/A | tile_data_short(f.home) | Tile data short of dead farmbit's home. | |  

### **BLURB**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| (none) | N/A |  | Event itself indicates that the player clicked to the next blurb in a tutorial etc. (the tutorial itself is the last tutorial event logged). | |  

### **CLICK**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| (not currently implemented) | N/A |  |  | |  

### **RAINSTOPPED**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| (none) | N/A |  | Log itself indicates that it was raining and the raining has now stopped. | |  

### **HISTORY**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| client_time | N/A | now | current client time | |
| camera_history | N/A | flush_camera_history(now) | List of [camera moves](#CameraMove) since last history log. | |
| emote_history | N/A | flush_emote_history(now) | List of 11 element sublists [[farmbit](#DataShort), [emote index](#Emotes), time before client_time (negative number)] emotes since last history log. | |  

### **ENDGAME**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| (none) | N/A |  | Log itself indicates the player has left the game page. Seperate history and gamestate logs are sent. | |  

### **EMOTE**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| farmbit | N/A | farmbit_data_short(t) | See [Data Short](#DataShort). | |
| emote_enum | N/A | emote_id | See [emotes](#Emotes). | |  

### **FARMFAIL**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| tile | N/A | tile_data_short(t) | Farm that failed. See [Data Short](#DataShort). | |
| marks | N/A | t.marks | Farm [mark indices](#Mark). | |  

### **BLOOM**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| tile | N/A | tile_data_short(t) | See [Data Short](#DataShort). | |
| marks | N/A | t.marks | Not relevant to lake tiles. Included for uniformity. | |  

### **FARMHARVESTED**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| tile | N/A | tile_data_short(t) | Farm that produced corn. See [Data Short](#DataShort). | |
| marks | N/A | t.marks | Tile [mark indices](#Mark). | |  

### **MILKPRODUCED**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| tile | N/A | tile_data_short(t) | Dairy that produced milk. See [Data Short](#DataShort). | |
| marks | N/A | t.marks | Tile [mark indices](#Mark). | |  

### **POOPPRODUCED**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| tile | N/A | tile_data_short(t) | Dairy that produced poop. See [Data Short](#DataShort). | |
| marks | N/A | t.marks | Tile [mark indices](#Mark). | |  

### **DEBUG**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| (none) | N/A |  | Event itself means that someone has used 'spyparty' to enter debug mode. | |  

### **NEWFARMBIT**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| farmbit | N/A | farmbit_data_short(t) | See [Data Short](#DataShort). | |  

## Detected Events  

The custom, data-driven Events calculated from this game's logged events by OpenGameData when an 'export' is run.  

None  

## Processed Features  

The features/metrics calculated from this game's event logs by OpenGameData when an 'export' is run.  

**HouseBuildCount** : *int*, *Aggregate feature*   
Count of House build  
  

**DairyBuildCount** : *int*, *Aggregate feature*   
Count of Dairy build  
  

**CropBuildCount** : *int*, *Aggregate feature*   
Count of Crop build  
  

**TotalBuildCount** : *int*, *Aggregate feature*   
Total Count of builds  
  

**HoversBeforeCropPlacement** : *int*, *Aggregate feature*   
Number of hovers before crop placement  
  

**TotalSessionTime** : *list*, *Aggregate feature*   
Total session time  
  

## Other Elements  

Other (potentially non-standard) elements specified in the game's schema, which may be referenced by event/feature processors.  

### Other Ranges  

Extra ranges specified in the game's schema, which may be referenced by event/feature processors.  

level_range : range(-1, -1)

No changelog prepared

