# Game: ICECUBE

No game-specific readme content prepared

## Field Day Open Game Data

Retrieved from https://fielddaylab.wisc.edu/opengamedata
These anonymous data are provided in service of future educational data mining research.
They are made available under the Creative Commons CCO 1.0 Universal license.
See https://creativecommons.org/publicdomain/zero/1.0/

### Suggested citation

#### Field Day. (2019). Open Educational Game Play Logs - [dataset ID]. Retrieved [today's date] from https://opengamedata.fielddaylab.wisc.edu/

## Database Columns

The individual columns recorded in the database for this game.

**session_id** : *str* - session_id, Unique identifier for the gameplay session  
**app_id** : *str* - app_id, A string identifying which game from which the event came  
**timestamp** : *datetime* - timestamp, The time when the event was logged  
**event_name** : *str* - event_name, The type of event logged  
**event_data** : *json* - event_data, Data specific to an event type, encoded as a JSON string  
**event_source** : *enum('GAME', 'GENERATED')* - event_source, An enum member indicating whether the event was generated by the Game, or by a Detector  
**app_version** : *str* - app_version, The version of the game from which the event came  
**app_branch** : *str* - app_branch, The branch of the game from which the event came  
**log_version** : *str* - log_version, The version of the logging code for the game from which the event came  
**offset** : *timezone* - offset, The local offset of the event time from GMT  
**user_id** : *str* - user_id, A custom, per-player ID, only exists if player entered an ID on one of our custom portal pages, else null  
**user_data** : *json* - user_data, Metadata specific to a user, encoded as a JSON string  
**game_state** : *json* - game_state, Metadata about the state of the game when the event occurred, encoded as a JSON string  
**index** : *int* - index, Counter of events in the session, from 0. A row with session_n = i is the (i+1)-th event of the session  

## Event Object Elements

The elements (member variables) of each Event object, available to programmers when writing feature extractors. The right-hand side shows which database column(s) are mapped to a given element.

**session_id** = Column '*session_id*' (index 0)  
**app_id** = Column '*app_id*' (index 1)  
**timestamp** = Column '*timestamp*' (index 2)  
**event_name** = Column '*event_name*' (index 3)  
**event_data** = Column '*event_data*' (index 4)  
**event_source** = Column '*event_source*' (index 5)  
**app_version** = Column '*app_version*' (index 6)  
**app_branch** = Column '*app_branch*' (index 7)  
**log_version** = Column '*log_version*' (index 8)  
**time_offset** = Column '*offset*' (index 9)  
**user_id** = Column '*user_id*' (index 10)  
**user_data** = Column '*user_data*' (index 11)  
**game_state** = Column '*game_state*' (index 12)  
**event_sequence_index** = Column '*index*' (index 13)  



## Logged Events  

The individual fields encoded in the *game_state* and *user_data* Event element for all event types, and the fields in the *event_data* Event element for each individual event type logged by the game.  

### Enums  

| **Name** | **Values** |
| ---      | ---        |  

### Game State  

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |  

### User Data  

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |  

### **headset_on**

Happens when the user puts on the headset, effectively a 'resume' event

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |  

### **start**

When the game actually starts

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| seconds_from_launch | float | The game time elapsed since the game app was launched | |  

### **language_selected**

When the player selects a language from the game menu

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| language | str | The language the player selected to use | |
| seconds_from_launch | float | The game time elapsed since the game app was launched | |  

### **scene_change**

When the player completes a scene, advancing to the next. Removed in version 2.

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| scene_name | enum(ICE, VOYAGER, NOTHING, EXTREME, EARTH, CREDITS) |  | |
| seconds_from_launch | float | The game time elapsed since the game app was launched | |  

### **scene_begin**

When the player starts a new scene. Added in version 2

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| scene_name | enum(ICE, VOYAGER, NOTHING, EXTREME, EARTH, CREDITS) | The scene the player is starting | |
| seconds_from_launch | float | The game time elapsed since the game app was launched | |  

### **scene_end**

When the player finishes a scene, before advancing to the next. Added in version 2.

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| scene_name | enum(ICE, VOYAGER, NOTHING, EXTREME, EARTH, CREDITS) | The scene the player just completed | |
| seconds_from_launch | float | The game time elapsed since the game app was launched | |  

### **new_object_displayed**

When a new object is displayed in the scene

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| has_the_indicator | bool |  | |
| object | str | The name of the object being displayed | |
| posX | float |  | |
| posY | float |  | |
| posZ | float |  | |
| rotX | float |  | |
| rotY | float |  | |
| rotZ | float |  | |
| rotW | float |  | |
| seconds_from_launch | float | The game time elapsed since the game app was launched | |  

### **object_assigned**

When the game assigns a target for the user to look at/select with their reticle

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| object | str | The ID of the assigned object | |
| seconds_from_launch | float | The game time elapsed since the game app was launched | |  

### **object_selected**

When the player selects a gaze point object with their reticle

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| gaze_point_name | str |  | |
| seconds_from_launch | float | The game time elapsed since the game app was launched | |  

### **caption_displayed**

When the captions for a voiceover are initially displayed

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| caption | str |  | |
| seconds_from_launch | float | The game time elapsed since the game app was launched | |  

### **script_audio_started**

When a voiceover audio clip begins

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| caption | str |  | |
| seconds_from_launch | float | The game time elapsed since the game app was launched | |  

### **script_audio_complete**

When a voiceover audio clip ends

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| seconds_from_launch | float | The game time elapsed since the game app was launched | |  

### **failed**

When a player fails a scene and must re-start the scene

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| seconds_from_launch | float | The game time elapsed since the game app was launched | |  

## Detected Events  

The custom, data-driven Events calculated from this game's logged events by OpenGameData when an 'export' is run.  

None  

## Processed Features  

The features/metrics calculated from this game's event logs by OpenGameData when an 'export' is run.  

**ScenesEncountered** : *List[str]*, *Aggregate feature*   
The set of all scenes the player encountered.  
  

## Other Elements  

Other (potentially non-standard) elements specified in the game's schema, which may be referenced by event/feature processors.  

### Other Ranges  

Extra ranges specified in the game's schema, which may be referenced by event/feature processors.  

level_range : range(1, 6)

No changelog prepared

