# Game: AQUALAB

No game-specific readme content prepared

## Field Day Open Game Data

Retrieved from https://fielddaylab.wisc.edu/opengamedata
These anonymous data are provided in service of future educational data mining research.
They are made available under the Creative Commons CCO 1.0 Universal license.
See https://creativecommons.org/publicdomain/zero/1.0/

### Suggested citation

#### Field Day. (2019). Open Educational Game Play Logs - [dataset ID]. Retrieved [today's date] from https://opengamedata.fielddaylab.wisc.edu/

## Database Columns

The individual columns recorded in the database for this game.

**session_id** : *str* - session_id, Unique identifier for the gameplay session  
**app_id** : *str* - app_id, A string identifying which game from which the event came  
**timestamp** : *datetime* - timestamp, The time when the event was logged  
**event_name** : *str* - event_name, The type of event logged  
**event_data** : *json* - event_data, Data specific to an event type, encoded as a JSON string  
**event_source** : *enum('GAME', 'GENERATED')* - event_source, An enum member indicating whether the event was generated by the Game, or by a Detector  
**app_version** : *str* - app_version, The version of the game from which the event came  
**app_branch** : *str* - app_branch, The branch of the game from which the event came  
**log_version** : *str* - log_version, The version of the logging code for the game from which the event came  
**offset** : *timezone* - offset, The local offset of the event time from GMT  
**user_id** : *str* - user_id, A custom, per-player ID, only exists if player entered an ID on one of our custom portal pages, else null  
**user_data** : *json* - user_data, Metadata specific to a user, encoded as a JSON string  
**game_state** : *json* - game_state, Metadata about the state of the game when the event occurred, encoded as a JSON string  
**index** : *int* - index, Counter of events in the session, from 0. A row with session_n = i is the (i+1)-th event of the session  

## Event Object Elements

The elements (member variables) of each Event object, available to programmers when writing feature extractors. The right-hand side shows which database column(s) are mapped to a given element.

**session_id** = Column '*session_id*' (index 0)  
**app_id** = Column '*app_id*' (index 1)  
**timestamp** = Column '*timestamp*' (index 2)  
**event_name** = Column '*event_name*' (index 3)  
**event_data** = Column '*event_data*' (index 4)  
**event_source** = Column '*event_source*' (index 5)  
**app_version** = Column '*app_version*' (index 6)  
**app_branch** = Column '*app_branch*' (index 7)  
**log_version** = Column '*log_version*' (index 8)  
**time_offset** = Column '*offset*' (index 9)  
**user_id** = Column '*user_id*' (index 10)  
**user_data** = Column '*user_data*' (index 11)  
**game_state** = Column '*game_state*' (index 12)  
**event_sequence_index** = Column '*index*' (index 13)  



## Logged Events  

The individual fields encoded in the *game_state* and *user_data* Event element for all event types, and the fields in the *event_data* Event element for each individual event type logged by the game.  

### Enums  

| **Name** | **Values** |
| ---      | ---        |  

### Game State  

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| job_name | str | The name of the current job | |  

### User Data  

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |  

### **accept_job**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |  

### **switch_job**

Event that occurs whenever the job switches, whether manually or through an `accept_job` or `complete_job`

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| prev_job_name | str | String name of the previous job, may be incorrect when coinciding with any `complete_job`, or with an `accept_job` at a time the user was actively in a job. | |  

### **receive_fact**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| fact_entity | str | The entity (e.g. species) with which the fact is associated | |
| fact_id | str | Unique ID for the given fact | |
| fact_rate | bool | Whether the fact is a... rate fact? I don't really get this one... | |
| fact_stressed | bool |  | |
| fact_type | str | The type of fact | |
| has_rate | bool | Whether the fact... has a rate? We need better naming of things I guess... | |  

### **receive_entity**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| entity_id | str | Unique ID for the given entity | |  

### **complete_job**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| job_name | str | String name of the completed job | |  

### **complete_task**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| task_id | str | ID of the completed task | |  

### **scene_changed**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| scene_name | str | Name of the loaded scene | |  

### **room_changed**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| room_name | str | Name of the room being entered | |  

### **begin_dive**

When the player enters a dive site in their submarine

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| site_id | str | ID of the dive site | |  

### **ask_for_help**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| node_id | str | Scripting ID for the hint response | |  

### **guide_script_triggered**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| node_id | str | Scripting ID for the guide's response | |  

### **script_fired**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| node_id | str | ID of a given script node | |  

### **open_bestiary**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |  

### **bestiary_open_species_tab**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |  

### **bestiary_open_environments_tab**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |  

### **bestiary_open_models_tab**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |  

### **bestiary_select_species**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| species_id | str | ID of the selected species | |  

### **bestiary_select_environment**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| environment_id | str | ID of the selected environment | |  

### **bestiary_select_model**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| model_id | str | ID of the selected model | |  

### **close_bestiary**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |  

### **open_status**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |  

### **status_open_job_tab**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |  

### **status_open_item_tab**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |  

### **status_open_tech_tab**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |  

### **close_status**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |  

### **begin_model**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |  

### **model_phase_changed**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| phase | str | The selected modeling phase | |  

### **model_ecosystem_selected**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| ecosystem | str | Ecosystem selected for modeling | |  

### **model_concept_started**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| ecosystem | str | Ecosystem selected for modeling | |  

### **model_concept_updated**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| ecosystem | str | Ecosystem selected for modeling | |
| status | str | Updated status of the concept model | |  

### **model_concept_exported**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| ecosystem | str | Ecosystem selected for modeling | |  

### **begin_simulation**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| ecosystem | str | Ecosystem selected for modeling | |  

### **model_sync_error**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| ecosystem | str | Ecosystem selected for modeling | |
| sync | int | Sync % achieved with the current model | |  

### **simulation_sync_achieved**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| ecosystem | str | Ecosystem selected for modeling | |  

### **model_predict_completed**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| ecosystem | str | Ecosystem selected for modeling | |  

### **model_intervene_update**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| ecosystem | str | Ecosystem selected for modeling | |
| organism | str | The organism having its population modified by the player | |
| difference_value | None | The population change for the selected organism | |  

### **model_intervene_error**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| ecosystem | str | Ecosystem selected for modeling | |  

### **model_intervene_completed**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| ecosystem | str | Ecosystem selected for modeling | |  

### **end_model**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| phase | str | The selected modeling phase upon leaving | |
| ecosystem | str | The selected ecosystem upon leaving | |  

### **purchase_upgrade**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| item_id | str | ID of the purchased item | |
| item_name | str | String name of the purchased item | |
| cost | None | Cost of the purchased item | |  

### **insufficient_funds**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| item_id | str | ID of the item | |
| item_name | str | String name of the item | |
| cost | None | Cost of the item | |  

### **talk_to_shopkeep**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |  

### **add_environment**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| tank_type | str | Selected tank type for the experiment | |
| environment | str | Name of the added environment | |  

### **remove_environment**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| tank_type | str | Selected tank type for the experiment | |
| environment | str | Name of the removed environment | |  

### **add_critter**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| tank_type | str | Selected tank type for the experiment | |
| environment | str | Selected environment for the experiment | |
| critter | str | Name of the critter added to the tank | |  

### **remove_critter**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| tank_type | str | Selected tank type for the experiment | |
| environment | str | Selected environment for the experiment | |
| critter | str | Name of the critter removed from the tank | |  

### **begin_experiment**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| tank_type | str | Selected tank type for the experiment | |
| environment | str | Selected environment for the experiment | |
| critters | str | Comma separated list of all critters added to the tank | |  

### **end_experiment**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| tank_type | str | Selected tank type for the experiment | |
| environment | str | Selected environment for the experiment | |
| critters | str | Comma separated list of all critters added to the tank | |  

### **begin_argument**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |  

### **fact_submitted**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| fact_id | str | ID of the submitted fact | |  

### **fact_rejected**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| fact_id | str | ID of the rejected fact | |  

### **leave_argument**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |  

### **complete_argument**

N/A

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |  

### **survey_submitted**

When the player completes an in-game survey and submits their response to the server

#### Event Data

| **Name** | **Type** | **Description** | **Sub-Elements** |
| ---      | ---      | ---             | ---         |
| display_event_id | str | An ID/name for the survey that was submitted | |
| package_config_id | str | An ID/name for the package of surveys that the submitted survey came from | |
| responses | List[Dict] | A list of individual response objects |**prompt** : str, **response** : int |  

## Detected Events  

The custom, data-driven Events calculated from this game's logged events by OpenGameData when an 'export' is run.  

**CollectFactNoJob** : *Detector*  (disabled)  
Triggers an event when a player collects a fact while not actively working on a job  
  

**DiveSiteNoEvidence** : *Detector*  (disabled)  
Triggers an event when a player has gone sufficiently long at a dive site without uncovering new evidence  
*Other elements*:  

threshold : 30  

**EchoRoomChange** : *Detector*  (disabled)  
Triggers an event when a player changes rooms.  
  

**HintAndLeave** : *Detector*  (disabled)  
  
*Other elements*:  

threshold : 30  

**Idle** : *Detector*  (disabled)  
  
*Other elements*:  

idle_level : 30  

**SceneChangeFrequently** : *Detector*  (disabled)  
  
*Other elements*:  

threshold : 30  

**TwoHints** : *Detector*  (disabled)  
  
*Other elements*:  

threshold : 30  

## Processed Features  

The features/metrics calculated from this game's event logs by OpenGameData when an 'export' is run.  

**ExperimentalCondition** : *str*, *Aggregate feature*   
Returns the first event branch  
  

**FinalBestiary** : *list*, *Aggregate feature*   
Returns the final contents of the bestiary, the last time the player switched jobs.  
*Sub-features*:  

- **Size** : *int*, The number of items in the bestiary  
  

**PlayedNonexperimentalVersion** : *str*, *Aggregate feature*   
True if the player ever had an event in a non-experimental branch.  
  

**TotalJobRecommendationReceived** : *int*, *Aggregate feature*   
Count of total recommendations received  
*Other elements*:  

target : recommended_job  

**ActiveJobs** : *dict*, *Aggregate feature*   
Count of players who left off on each job.  
  

**AppVersions** : *list*, *Aggregate feature*   
List of all app versions encountered.  
  

**ActiveTime** : *timedelta*, *Aggregate feature*  (disabled)  
Total time spent actively playing the game  
  

**EventList** : *list*, *Aggregate feature*  (disabled)  
List of key events that happened in a player's session(s)  
  

**JobQuitsPerComplete** : *list*, *Aggregate feature*   
Ratio of jobs quit to jobs completed.  
  

**JobsCompleted** : *list[str]*, *Aggregate feature*   
List of completed jobs for a player  
*Sub-features*:  

- **UniqueCount** : *int*, The number of unique jobs that were completed  

- **Names** : *List[str]*, The names of completed jobs, in order of completion  
  

**PlayerSummary** : *dict*, *Aggregate feature*   
Summary of player statistics (active session time, jobs completed, number of sessions)  
  

**PlayLocations** : *List[bool]*, *Aggregate feature*   
Play Locations  
*Sub-features*:  

- **LocalTime** : *datetime*, An indicator of whether play happened during normal school hours or not  
  

**PopulationSummary** : *dict*, *Aggregate feature*   
Summary of population statistics (active session time, average jobs completed count, average session count)  
  

**SessionDiveSitesCount** : *int*, *Aggregate feature*   
Time spent playing in a given session  
  

**SessionDuration** : *timedelta*, *Aggregate feature*   
Time spent playing in a given session  
*Sub-features*:  

- **Seconds** : *float*, The total play time, whether active or idle, in seconds  

- **Active** : *timedelta*, The active play time, i.e. play without any gaps above the threshold, as a timedelta  

- **ActiveSeconds** : *float*, The active play time, i.e. play without any gaps above the threshold, in seconds  

- **Idle** : *float*, The total time spent idle  

- **IdleSeconds** : *timedelta*, The idle time, in seconds  

- **MaxIdle** : *float*, The longest time spent idle  
*Other elements*:  

threshold : 60  

**SessionID** : *str*, *Aggregate feature*  (disabled)  
The player's session ID number for this play session  
  

**SwitchJobsCount** : *int*, *Aggregate feature*   
Number of times player switched jobs before completion  
  

**TopJobCompletionDestinations** : *str*, *Aggregate feature*  (disabled)  
Top five most accepted jobs after previously completing a given job  
  

**TopJobSwitchDestinations** : *str*, *Aggregate feature*  (disabled)  
Top five most accepted jobs after switching away from a given job  
  

**TotalArgumentationTime** : *timedelta*, *Aggregate feature*   
Total time spent in argumentation  
  

**TotalDiveTime** : *timedelta*, *Aggregate feature*   
Total time spent in dive sites  
  

**TotalExperimentationTime** : *timedelta*, *Aggregate feature*   
Total time spent in experimentation  
  

**TotalModelingTime** : *timedelta*, *Aggregate feature*   
Total time spent in modeling  
  

**TotalGuideCount** : *int*, *Aggregate feature*   
Number of times player talked with the guide throughout the session  
  

**TotalHelpCount** : *int*, *Aggregate feature*   
Number of times player clicked the help button throughout the session  
  

**TotalJobQuits** : *int*, *Aggregate feature*   
Number of times player quit a job  
  

**TotalPlayTime** : *timedelta*, *Aggregate feature*   
Total time the player had the game open, based on sum total of SessionDurations.  
  

**TotalSessionTime** : *timedelta*, *Aggregate feature*   
Total time spent playing in a given session  
*Other elements*:  

threshold : 30  

**TotalPopulationTime** : *timedelta*, *Aggregate feature*   
Total population playing in a given session  
*Other elements*:  

threshold : 30  

**TotalPlayerTime** : *timedelta*, *Aggregate feature*   
Total players playing in a given session  
*Other elements*:  

threshold : 30  

**TimeInJournal** : *timedelta*, *Aggregate feature*   
Tracks total, active, and idle time spent in the journal.  
*Sub-features*:  

- **Seconds** : *float*, Total time spent in the journal, in seconds.  

- **Active** : *timedelta*, Total active time in the journal.  

- **ActiveSeconds** : *float*, Active time in the journal, in seconds.  

- **Idle** : *timedelta*, Total idle time in the journal.  

- **IdleSeconds** : *float*, Idle time in the journal, in seconds.  
  

**UserAvgSessionDuration** : *float*, *Aggregate feature*   
Average session duration for a user.  
  

**UserTotalSessionDuration** : *timedelta*, *Aggregate feature*   
Total duration of all sessions for a user.  
  

**FollowedAdvice** : *bool*, *Per-count feature*   
followed advice during a job  
  

**JobTriesInArgument** : *int*, *Per-count feature*   
  
  

**JobTriesInArgumentPerDifficulty** : *int*, *Per-count feature*   
  
  

**JobPriorComplete** : *list*, *Per-count feature*   
  
  

**JobPriorAttempt** : *list*, *Per-count feature*   
  
  

**JobActiveTime** : *timedelta*, *Per-count feature*  (disabled)  
Time spent with job as the active job  
  

**JobArgumentation** : *timedelta*, *Per-count feature*   
Number of times the player entered the argumentation mechanic during a job  
*Sub-features*:  

- **Time** : *timedelta*, Time spent in argumentation during a job  
  

**JobAttempted** : *bool*, *Per-count feature*   
Indicator for whether the player ever entered into the given job  
  

**JobTotalAttempts** : *int*, *Per-count feature*   
The total number of players who attempted the job.  
  

**JobArgumentationRejects** : *float*, *Per-count feature*   
Number of fact_rejected per job  
  

**JobArgumentationFails** : *float*, *Per-count feature*   
Number of times argumentation left per job  
  

**JobCompletionTime** : *timedelta*, *Per-count feature*  (disabled)  
Time taken to complete a given job  
  

**JobDiveSitesCount** : *int*, *Per-count feature*   
Number of dive sites visited during a job  
  

**JobDiveTime** : *timedelta*, *Per-count feature*   
Time spent diving during a job  
  

**JobExperimentation** : *timedelta*, *Per-count feature*   
Number of times the player entered the experimentation mechanic during a job  
*Sub-features*:  

- **Time** : *timedelta*, Time spent in experimentation during a job  
  

**JobGuideCount** : *int*, *Per-count feature*  (disabled)  
Number of times player talked with guide during a job  
  

**JobName** : *str*, *Per-count feature*   
The name of the job associated with job0, job1, etc.  
  

**JobHelpCount** : *int*, *Per-count feature*  (disabled)  
Number of times player asked for help during a job  
*Sub-features*:  

- **ByTask** : *int*, Help counts leading up to each completed task  
  

**JobLocationChanges** : *int*, *Per-count feature*  (disabled)  
Number of times player changed scenes or rooms  
*Sub-features*:  

- **ByTask** : *int*, Change counts leading up to each completed task  
  

**JobLocationChangesNoKelp** : *int*, *Per-count feature*   
N/A  
*Sub-features*:  

- **ByTask** : *int*, N/A  
  

**JobRecommendationReceived** : *int*, *Per-count feature*   
Number of times player received a job recommendation  
  

**LeftJob** : *int*, *Per-count feature*   
Job left off on by player  
  

**SessionDurationPerJob** : *timedelta*, *Per-count feature*   
N/A  
*Sub-features*:  

- **Total** : *timedelta*, The total play time per job  

- **Seconds** : *float*, The total play time per job, whether active or idle, in seconds  

- **Active** : *timedelta*, The active play time per job, i.e. play without any gaps above the threshold, as a timedelta  

- **ActiveSeconds** : *float*, The active play time per job, i.e. play without any gaps above the threshold, in seconds  

- **Idle** : *timedelta*, The idle time per job i.e. player does not play or is afk  

- **IdleSeconds** : *float*, The idle time per job i.e. player does not play or is afk, in seconds  

- **MaxIdle** : *timedelta*, The maximum idle time per job  
*Other elements*:  

threshold : 60  

**JobModeling** : *timedelta*, *Per-count feature*   
Number of times the player entered the modeling mechanic during a job  
*Sub-features*:  

- **Time** : *timedelta*, Time spent in modeling during a job  
  

**JobTasksCompleted** : *List[str]*, *Per-count feature*   
List of tasks completed for a given job  
*Sub-features*:  

- **Count** : *int*, Number of tasks completed for the given job  
  

**JobArgumentationSuccessRatio** : *float*, *Per-count feature*   
Ratio of facts accepted against total facts submitted  
  

**JobArgumentationNoReject** : *int*, *Per-count feature*   
Whether or not a job was completed with zero rejected facts  
  

**JobsAttempted** : **, *Per-count feature*  (disabled)  
Subfeatures for number of job starts and completes, percent complete, and avg/std time to complete  
*Sub-features*:  

- **job-name** : *string*, String name for a job  

- **num-starts** : *int*, Number of accept_job events for a given job id  

- **num-completes** : *int*, Number of complete_job events for a given job id  

- **percent-complete** : *float*, Percent of jobs which were accepted and completed  

- **avg-time-per-attempt** : *float*, Average time taken from accepting to completing/leaving a job  

- **std-dev-per-attempt** : *float*, Standard deviation of time taken on a job  

- **job-difficulties** : *dict*, Difficulty of experimentation, modeling, and argumentation phases in the job  
  

**RegionJobCount** : *int*, *Per-count feature*   
The number of jobs completed in a given region  
  

**RegionName** : *str*, *Per-count feature*   
The human-readable version of the name for a given region  
  

**SuccessfulAdvice** : *bool*, *Per-count feature*   
successfully followed advice during a job  
  

**SurveyCompleted** : *bool*, *Per-count feature*   
Survey completed during a job  
*Sub-features*:  

- **Name** : *string*, String name of the survey  

- **Responses** : *int*,   
  

**DemographicItemResponses** : *int | str*, *Per-count feature*   
Responses to each item on the demographics survey  
*Sub-features*:  

- **Prompt** : *string*, The full text content of the prompt  

- **Count** : *int*, The number of times the player responded to this survey  
*Other elements*:  

target : demographics
retest : False  

**AffectItemResponses** : *int | str*, *Per-count feature*   
Responses to each item on the affective state survey  
*Sub-features*:  

- **Retest** : *int | str*, The response the player gave upon taking the survey a second time  

- **Prompt** : *string*, The full text content of the prompt  

- **Count** : *int*, The number of times the player responded to this survey  
*Other elements*:  

target : affective
retest : True  

**ScienceEfficacyItemResponses** : *int | str*, *Per-count feature*   
Responses to each item on the science self-efficacy survey  
*Sub-features*:  

- **Retest** : *int | str*, The response the player gave upon taking the survey a second time  

- **Prompt** : *string*, The full text content of the prompt  

- **Count** : *int*, The number of times the player responded to this survey  
*Other elements*:  

target : science-efficacy
retest : True  

**ScienceIdentityItemResponses** : *int | str*, *Per-count feature*   
Responses to each item on the science identity survey  
*Sub-features*:  

- **Retest** : *int | str*, The response the player gave upon taking the survey a second time  

- **Prompt** : *string*, The full text content of the prompt  

- **Count** : *int*, The number of times the player responded to this survey  
*Other elements*:  

target : science-identity
retest : True  

**ScienceInterestItemResponses** : *int | str*, *Per-count feature*   
Responses to each item on the science interest survey  
*Sub-features*:  

- **Retest** : *int | str*, The response the player gave upon taking the survey a second time  

- **Prompt** : *string*, The full text content of the prompt  

- **Count** : *int*, The number of times the player responded to this survey  
*Other elements*:  

target : science-interest
retest : True  

**HansonInterestsItemResponses** : *int | str*, *Per-count feature*   
Responses to each item on the Hanson interests survey  
*Sub-features*:  

- **Prompt** : *string*, The full text content of the prompt  

- **Count** : *int*, The number of times the player responded to this survey  
*Other elements*:  

target : interest-items-hanson-2021
retest : False  

**Values1ItemResponses** : *int | str*, *Per-count feature*   
Responses to each item on the values survey, part 1  
*Sub-features*:  

- **Prompt** : *string*, The full text content of the prompt  

- **Count** : *int*, The number of times the player responded to this survey  
*Other elements*:  

target : values-1
retest : False  

**Values2ItemResponses** : *int | str*, *Per-count feature*   
Responses to each item on the values survey, part 2  
*Sub-features*:  

- **Prompt** : *string*, The full text content of the prompt  

- **Count** : *int*, The number of times the player responded to this survey  
*Other elements*:  

target : values-2
retest : False  

**Values3ItemResponses** : *int | str*, *Per-count feature*   
Responses to each item on the values survey, part 3  
*Sub-features*:  

- **Prompt** : *string*, The full text content of the prompt  

- **Count** : *int*, The number of times the player responded to this survey  
*Other elements*:  

target : values-3
retest : False  

**Values4ItemResponses** : *int | str*, *Per-count feature*   
Responses to each item on the values survey, part 4  
*Sub-features*:  

- **Prompt** : *string*, The full text content of the prompt  

- **Count** : *int*, The number of times the player responded to this survey  
*Other elements*:  

target : values-4
retest : False  

**Values5ItemResponses** : *int | str*, *Per-count feature*   
Responses to each item on the values survey, part 5  
*Sub-features*:  

- **Prompt** : *string*, The full text content of the prompt  

- **Count** : *int*, The number of times the player responded to this survey  
*Other elements*:  

target : values-5
retest : False  

**Values6ItemResponses** : *int | str*, *Per-count feature*   
Responses to each item on the values survey, part 6  
*Sub-features*:  

- **Prompt** : *string*, The full text content of the prompt  

- **Count** : *int*, The number of times the player responded to this survey  
*Other elements*:  

target : values-6
retest : False  

**Values7ItemResponses** : *int | str*, *Per-count feature*   
Responses to each item on the values survey, part 7  
*Sub-features*:  

- **Prompt** : *string*, The full text content of the prompt  

- **Count** : *int*, The number of times the player responded to this survey  
*Other elements*:  

target : values-7
retest : False  

**EnjoymentItemResponses** : *int | str*, *Per-count feature*   
Responses to each item on the enjoyment survey  
*Sub-features*:  

- **Prompt** : *string*, The full text content of the prompt  

- **Count** : *int*, The number of times the player responded to this survey  
*Other elements*:  

target : enjoyment
retest : False  

**SyncCompletionTime** : *timedelta*, *Per-count feature*   
Time taken to achieve 100% sync in a simulation  
  

## Other Elements  

Other (potentially non-standard) elements specified in the game's schema, which may be referenced by event/feature processors.  

### Other Ranges  

Extra ranges specified in the game's schema, which may be referenced by event/feature processors.  

level_range : range(0, 56)  

diff_range : range(0, 5)  

task_range : range(0, 235)

No changelog prepared

